<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

// import Joomla controllerform library
jimport('joomla.application.component.controllerform');

/**
 * Event Controller
 */
class TimetableControllerEvent extends JControllerForm
{
	protected function postSaveHook(JModelLegacy $model, $validData = array()) {		
		if($_POST['jform']){
			$event_id = $model->getItem()->get('id'); 
			$original = JRequest::getVar('jform', array(), 'post', 'array');
			$db = JFactory::getDbo();
			// Intercept additional options for event and event hours
			$event_hours = array();
			foreach($original as $key=>$value){
				if(strpos($key, "event_hours_") !== FALSE) {
					$count = count($original[$key]);
					for($i=0; $i<$count; $i++) {
						$event_hours[str_replace("event_hours_", "", $key)][$i] = $value[$i];
					}
				}
			}
			
			// Save event hours
			if(!empty($event_hours)) {
				reset($event_hours);
				$first_key = key($event_hours);
				$event_hours_count = count($event_hours[$first_key]);
				for($i=0; $i<$event_hours_count; $i++) {
					$query = "INSERT INTO 
						#__timetable_event_hours(
							`event_id`,
							`weekday_id`,
							`start`,
							`end`,
							`tooltip`,
							`before_hour_text`,
							`after_hour_text`,
							`category`)
						VALUES (
						'" . $event_id . "',
						'" . $event_hours['columns'][$i] . "',
						'" . $event_hours['start_hours'][$i] . "',
						'" . $event_hours['end_hours'][$i] . "',
						'" . addslashes($event_hours['tooltips'][$i]) . "',
						'" . addslashes($event_hours['descriptions_1'][$i]) . "',
						'" . addslashes($event_hours['descriptions_2'][$i]) . "',
						'" . $event_hours['categories'][$i] . "'
					);";

					$db->setQuery($query);
					$db->query();
				}
			}

			// Delete event hours
			if(!empty($original["delete_event_hours_ids"])) {
				$delete_event_hours_ids = $original["delete_event_hours_ids"];
				$delete_event_hours_ids_count = count($delete_event_hours_ids);
				if($delete_event_hours_ids_count) {
					$query = $db->getQuery(true);
					$conditions = array(
						$db->quoteName('id') . ' IN(' . implode(",", $delete_event_hours_ids) . ') '
					);
					$query->delete($db->quoteName('#__timetable_event_hours'));
					$query->where($conditions);
					$db->setQuery($query);
					$db->query();
				}
			}
			
			// save event categories
			if(!empty($original["categories"])) {
				$query = "DELETE
					FROM 
						#__timetable_event_categories 
					WHERE 
						event_id = '{$event_id}'";
				$db->setQuery($query);
				$db->execute();
				
				$query = "INSERT INTO #__timetable_event_categories(event_id, category_id) VALUES";
				foreach($original["categories"] as $category) {
					//$event_id
					$query .= "('{$event_id}', '{$category}'),";
				}
				$query = rtrim($query, ",");
				$db->setQuery($query);
				$db->execute();
			}
		}
	}		
}